package ru.yandex.solomon.slog;

import ru.yandex.solomon.codec.CorruptedBinaryDataRuntimeException;

/**
 * See https://a.yandex-team.ru/arc/trunk/arcadia/solomon/libs/cpp/slog/log_data.h#L26
 * @author Vladimir Gordiychuk
 */
public enum DataCodingScheme {
    POINTS((byte) 0x0),
    ARCHIVES((byte) 0x1);

    public final byte num;

    DataCodingScheme(byte num) {
        this.num = num;
    }

    public static DataCodingScheme valueOf(byte value) {
        for (var scheme : DataCodingScheme.values()) {
            if (scheme.num == value) {
                return scheme;
            }
        }
        throw new CorruptedBinaryDataRuntimeException("unknown data coding scheme: " + Byte.toString(value));
    }
}
