package ru.yandex.solomon.slog;

import io.netty.buffer.ByteBuf;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Vladimir Gordiychuk
 */
public class Log implements AutoCloseable, MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(Log.class);

    public final int numId;
    public final ByteBuf meta;
    public final ByteBuf data;

    public Log(int numId, ByteBuf meta, ByteBuf data) {
        this.numId = numId;
        this.meta = meta;
        this.data = data;
    }

    public int getSizeBytes() {
        return meta.readableBytes() + data.readableBytes();
    }

    @Override
    public void close() {
        meta.release();
        data.release();
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + MemoryCounter.byteBufSize(meta) + MemoryCounter.byteBufSize(data);
    }

    @Override
    public String toString() {
        return "Log{" +
                "numId=" + Integer.toUnsignedLong(numId) +
                ", metaSize=" + DataSize.shortString(meta.readableBytes()) +
                ", dataSize=" + DataSize.shortString(data.readableBytes()) +
                '}';
    }
}
