package ru.yandex.solomon.slog;

import io.netty.buffer.ByteBuf;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;

/**
 * @author Vladimir Gordiychuk
 */
public interface LogDataBuilder extends AutoCloseable {
    /**
     * @param tsMillis common time for all provided timeseries
     */
    void onCommonTime(long tsMillis);

    /**
     * @return count bytes used to store point
     */
    int onPoint(MetricType type, int flags, AggrPoint point);

    /**
     * @return count bytes used to store points
     */
    int onTimeSeries(MetricType type, int flags, AggrGraphDataArrayList timeSeries);

    ByteBuf build();

    @Override
    void close();
}
