package ru.yandex.solomon.slog;

import javax.annotation.WillNotClose;

import io.netty.buffer.ByteBuf;

import ru.yandex.solomon.codec.UnsupportedFormatRuntimeException;
import ru.yandex.solomon.codec.archive.MetricArchiveMutable;

/**
 * @author Vladimir Gordiychuk
 */
public interface LogDataIterator extends AutoCloseable {

    int getNumId();

    int getPointsCount();

    int getMetricsCount();

    boolean hasNext();

    void next(MetricArchiveMutable archive);

    @Override
    void close();

    static LogDataIterator create(@WillNotClose ByteBuf buffer) {
        short magic = buffer.getShortLE(buffer.readerIndex());
        switch (magic) {
            case LogDataHeader.VALID_MAGIC:
                return new LogDataIteratorImpl(new LogDataHeader(buffer), buffer);
            case SnapshotLogDataHeader.VALID_MAGIC:
                return new SnapshotLogDataIteratorImpl(new SnapshotLogDataHeader(buffer), buffer);
            default:
                throw new UnsupportedFormatRuntimeException("invalid magic " + Integer.toString(magic, 16) + " for data");
        }
    }
}
