package ru.yandex.solomon.slog;

import ru.yandex.misc.lang.ByteUtils;
import ru.yandex.solomon.codec.UnsupportedFormatRuntimeException;

/**
 * @author Vladimir Gordiychuk
 */
public enum LogDataVersion {
    INIT_1(1),
    ARCHIVES_2(2);

    private static final LogDataVersion[] VALUES = values();
    public static final LogDataVersion CURRENT = ARCHIVES_2;

    final byte number;

    LogDataVersion(int number) {
        this.number = ByteUtils.toByteExact(number);
    }

    public static LogDataVersion valueOf(byte number) {
        for (var version : VALUES) {
            if (version.number == number) {
                return version;
            }
        }

        throw new UnsupportedFormatRuntimeException("Unknown version: " + number);
    }

    public static LogDataVersion valueOf(int number) {
        return valueOf(ByteUtils.toByteExact(number));
    }
}
