package ru.yandex.solomon.slog;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.encode.spack.format.MetricTypes;
import ru.yandex.monlib.metrics.encode.spack.format.MetricValuesType;
import ru.yandex.solomon.slog.compression.EncodeStream;

/**
 * @author Vladimir Gordiychuk
 */
public class ResolvedLogMetaBuilderImpl implements ResolvedLogMetaBuilder {
    private final ResolvedLogMetaHeader header;
    private final EncodeStream encodeStream;
    private boolean build;

    public ResolvedLogMetaBuilderImpl(ResolvedLogMetaHeader header, ByteBufAllocator allocator) {
        if (header.metricsCount != 0 || header.pointsCount != 0) {
            throw new IllegalStateException("Not valid header: " + header);
        }
        this.header = header;
        this.encodeStream = EncodeStream.create(header.compressionAlg, allocator);
        this.encodeStream.writeHeader(buf -> buf.writeZero(header.size()));
    }

    @Override
    public void onMetric(MetricType type, long localId, int points, int byteSize) {
        encodeStream.writeByte(MetricTypes.pack(type, MetricValuesType.NONE));
        encodeStream.writeLongLe(localId);
        encodeStream.writeVarint32(points);
        encodeStream.writeVarint32(byteSize);
        header.metricsCount++;
        header.pointsCount += points;
    }

    @Override
    public ByteBuf build() {
        if (build) {
            throw new IllegalStateException("Already build");
        }

        var buffer = encodeStream.finishStream();
        int pos = buffer.writerIndex();
        header.writeTo(buffer.resetWriterIndex());
        buffer.writerIndex(pos);
        build = true;
        return buffer;
    }

    @Override
    public void close() {
        encodeStream.close();
    }
}
