package ru.yandex.solomon.slog;

import javax.annotation.WillNotClose;

import io.netty.buffer.ByteBuf;

import ru.yandex.monlib.metrics.encode.spack.format.MetricTypes;
import ru.yandex.solomon.slog.compression.DecodeStream;

/**
 * @author Vladimir Gordiychuk
 */
public class ResolvedLogMetaIteratorImpl implements ResolvedLogMetaIterator {
    private final ResolvedLogMetaHeader header;
    private final DecodeStream in;
    private int pos;

    public ResolvedLogMetaIteratorImpl(@WillNotClose ByteBuf in) {
        this(new ResolvedLogMetaHeader(in), in);
    }

    public ResolvedLogMetaIteratorImpl(ResolvedLogMetaHeader header, @WillNotClose ByteBuf in) {
        this.header = header;
        this.in = DecodeStream.create(header.compressionAlg, in.retain());
    }

    @Override
    public boolean next(ResolvedLogMetaRecord record) {
        if (pos++ >= header.metricsCount) {
            return false;
        }

        record.type = MetricTypes.metricType(in.readByte());
        record.localId = in.readLongLe();
        record.points = in.readVarint32();
        record.dataSize = in.readVarint32();
        return true;
    }

    @Override
    public void close() {
        in.close();
    }
}
