package ru.yandex.solomon.slog;

import ru.yandex.monlib.metrics.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class ResolvedLogMetaRecord {
    public MetricType type;
    public long localId;
    public int points;
    public int dataSize;

    public ResolvedLogMetaRecord() {
    }

    public ResolvedLogMetaRecord(MetricType type, long localId, int points, int dataSize) {
        this.type = type;
        this.localId = localId;
        this.points = points;
        this.dataSize = dataSize;
    }

    @Override
    public String toString() {
        return "LogMetaRecord{" +
            "type=" + type +
            ", localId=" + Long.toUnsignedString(localId) +
            ", points=" + points +
            ", dataSize=" + dataSize +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ResolvedLogMetaRecord that = (ResolvedLogMetaRecord) o;

        if (localId != that.localId) return false;
        if (points != that.points) return false;
        if (dataSize != that.dataSize) return false;
        return type == that.type;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (int) (localId ^ (localId >>> 32));
        result = 31 * result + points;
        result = 31 * result + dataSize;
        return result;
    }
}
