package ru.yandex.solomon.slog;

import ru.yandex.misc.lang.ByteUtils;
import ru.yandex.solomon.codec.UnsupportedFormatRuntimeException;

/**
 * @author Vladimir Gordiychuk
 */
public enum ResolvedLogMetaVersion {
    INIT_1(1);

    private static final ResolvedLogMetaVersion[] VALUES = values();
    public static final ResolvedLogMetaVersion CURRENT = INIT_1;

    final byte number;

    ResolvedLogMetaVersion(int number) {
        this.number = ByteUtils.toByteExact(number);
    }

    public static ResolvedLogMetaVersion valueOf(int number) {
        return valueOf(ByteUtils.toByteExact(number));
    }

    public static ResolvedLogMetaVersion valueOf(byte number) {
        for (var version : VALUES) {
            if (version.number == number) {
                return version;
            }
        }

        throw new UnsupportedFormatRuntimeException("Unknown version: " + number);
    }
}
