package ru.yandex.solomon.slog;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class ResolvedLogMetricsRecord {
    public MetricType type;
    public Labels labels;
    public int shardId;
    public long localId;

    public ResolvedLogMetricsRecord() {
    }

    public ResolvedLogMetricsRecord(MetricType type, Labels labels, int shardId, long localId) {
        this.type = type;
        this.labels = labels;
        this.shardId = shardId;
        this.localId = localId;
    }

    @Override
    public String toString() {
        return "ResolvedLogMetricsRecord{" +
            "type=" + type +
            ", labels=" + labels +
            ", shardId=" + shardId +
            ", localId=" + Long.toUnsignedString(localId) +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ResolvedLogMetricsRecord)) return false;

        ResolvedLogMetricsRecord that = (ResolvedLogMetricsRecord) o;

        if (shardId != that.shardId) return false;
        if (localId != that.localId) return false;
        if (type != that.type) return false;
        return labels.equals(that.labels);
    }

    @Override
    public int hashCode() {
        int result = type.hashCode();
        result = 31 * result + labels.hashCode();
        result = 31 * result + shardId;
        result = 31 * result + (int) (localId ^ (localId >>> 32));
        return result;
    }
}
