package ru.yandex.solomon.slog;

import ru.yandex.misc.lang.ByteUtils;
import ru.yandex.solomon.codec.UnsupportedFormatRuntimeException;

/**
 * @author Vladimir Gordiychuk
 */
public enum SnapshotLogDataVersion {
    INIT_1(1);

    private static final SnapshotLogDataVersion[] VALUES = values();
    public static final SnapshotLogDataVersion CURRENT = INIT_1;

    final byte number;

    SnapshotLogDataVersion(int number) {
        this.number = ByteUtils.toByteExact(number);
    }

    public static SnapshotLogDataVersion valueOf(byte number) {
        for (var version : VALUES) {
            if (version.number == number) {
                return version;
            }
        }

        throw new UnsupportedFormatRuntimeException("Unknown version: " + number);
    }

    public static SnapshotLogDataVersion valueOf(int number) {
        return valueOf(ByteUtils.toByteExact(number));
    }
}
