package ru.yandex.solomon.slog;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.solomon.slog.compression.EncodeStream;

/**
 * @author Vladimir Gordiychuk
 */
public class StringPoolEncoder implements AutoCloseable {
    private final Object2IntOpenHashMap<String> pool;
    private final EncodeStream out;
    private int bytesSize;

    public StringPoolEncoder(CompressionAlg alg, ByteBufAllocator allocator) {
        this.out = EncodeStream.create(alg, allocator);
        this.pool = new Object2IntOpenHashMap<>();
        pool.defaultReturnValue(-1);
    }

    public int writeString(String str) {
        int idx = pool.getInt(str);
        if (idx == -1) {
            idx = pool.size();
            pool.put(str, idx);
            out.writeString(str);
            bytesSize += str.length() + 1;
        }
        return idx;
    }

    public int getBytesSize() {
        return bytesSize;
    }

    public boolean isEmpty() {
        return pool.isEmpty();
    }

    public ByteBuf finish() {
        return out.finish();
    }

    @Override
    public void close() {
        out.close();
    }
}
