package ru.yandex.solomon.slog;

import java.util.Objects;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class UnresolvedLogMetaRecord {
    public MetricType type;
    public Labels labels;
    public int points;
    public int dataSize;

    public UnresolvedLogMetaRecord() {
    }

    public UnresolvedLogMetaRecord(MetricType type, Labels labels, int points, int dataSize) {
        this.type = type;
        this.labels = labels;
        this.points = points;
        this.dataSize = dataSize;
    }

    @Override
    public String toString() {
        return "LogMetaRecord{" +
            "type=" + type +
            ", labels=" + labels +
            ", points=" + points +
            ", dataSize=" + dataSize +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UnresolvedLogMetaRecord record = (UnresolvedLogMetaRecord) o;

        if (points != record.points) return false;
        if (dataSize != record.dataSize) return false;
        if (type != record.type) return false;
        return Objects.equals(labels, record.labels);
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (labels != null ? labels.hashCode() : 0);
        result = 31 * result + points;
        result = 31 * result + dataSize;
        return result;
    }
}
