package ru.yandex.solomon.slog;

import ru.yandex.misc.lang.ByteUtils;
import ru.yandex.solomon.codec.UnsupportedFormatRuntimeException;

/**
 * @author Vladimir Gordiychuk
 */
public enum UnresolvedLogMetaVersion {
    INIT_1(1);

    private static final UnresolvedLogMetaVersion[] VALUES = values();
    public static final UnresolvedLogMetaVersion CURRENT = INIT_1;

    final byte number;

    UnresolvedLogMetaVersion(int number) {
        this.number = ByteUtils.toByteExact(number);
    }

    public static UnresolvedLogMetaVersion valueOf(int number) {
        return valueOf(ByteUtils.toByteExact(number));
    }

    public static UnresolvedLogMetaVersion valueOf(byte number) {
        for (var version : VALUES) {
            if (version.number == number) {
                return version;
            }
        }

        throw new UnsupportedFormatRuntimeException("Unknown version: " + number);
    }
}
