package ru.yandex.solomon.slog.compression;

import javax.annotation.WillClose;

import io.netty.buffer.ByteBuf;

import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.solomon.slog.compression.alg.Lz4Decompressor;
import ru.yandex.solomon.slog.compression.alg.ZlibDecompressor;
import ru.yandex.solomon.slog.compression.alg.ZstdDecompressor;

/**
 * @author Vladimir Gordiychuk
 */
public interface DecodeStream extends AutoCloseable {
    byte readByte();
    int readIntLe();
    int readShortLe();
    long readLongLe();
    double readDoubleLe();
    int readVarint32();
    String readString();
    void read(byte[] buffer, int offset, int length);
    void read(ByteBuf buffer, int length);
    void skipBytes(int length);

    @Override
    void close();

    static DecodeStream create(CompressionAlg alg, @WillClose ByteBuf buffer) {
        switch (alg) {
            case NONE: return new UncompressedDecodeStream(buffer); // 8 KiB
            case ZLIB: return new CompressDecodeStream(buffer, ZlibDecompressor.newInstance());
            case ZSTD: return new CompressDecodeStream(buffer, ZstdDecompressor.newInstance());
            case LZ4: return new CompressDecodeStream(buffer, Lz4Decompressor.newInstance());
            default:
                throw new RuntimeException("unsupported decompression algorithm: " + alg);
        }
    }
}
