package ru.yandex.solomon.slog.compression;

import java.util.function.Consumer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.solomon.slog.compression.alg.Lz4Compressor;
import ru.yandex.solomon.slog.compression.alg.ZlibCompressor;
import ru.yandex.solomon.slog.compression.alg.ZstdCompressor;

/**
 * @author Vladimir Gordiychuk
 * @see ru.yandex.monlib.metrics.encode.spack.compression.EncodeStream
 */
public interface EncodeStream extends AutoCloseable {
    void writeHeader(Consumer<ByteBuf> writer);
    void writeByte(byte value);
    void writeIntLe(int value);
    void writeShortLe(int value);
    void writeLongLe(long value);
    void writeDouble(double value);
    void writeString(String value);
    void writeVarint32(int value);
    void write(byte[] buffer, int offset, int length);
    void write(ByteBuf buffer, int offset, int length);
    void write(DecodeStream from, int length);

    ByteBuf finish();
    ByteBuf finishStream();

    @Override
    void close();

    static EncodeStream create(CompressionAlg alg, ByteBufAllocator allocator) {
        switch (alg) {
            case NONE: return new UncompressedEncodeStream(allocator, 64, Integer.MAX_VALUE);
            case ZLIB: return new CompressEncodeStream(allocator, ZlibCompressor.newInstance());
            case ZSTD: return new CompressEncodeStream(allocator, ZstdCompressor.newInstance());
            case LZ4: return new CompressEncodeStream(allocator, Lz4Compressor.newInstance());
            default:
                throw new RuntimeException("unsupported compression algorithm: " + alg);
        }
    }
}
