package ru.yandex.solomon.slog.compression.alg;

import java.nio.ByteBuffer;

import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

import ru.yandex.solomon.slog.compression.checksum.XxHash32Checksum;

/**
 * @author Vladimir Gordiychuk
 * @see ru.yandex.monlib.metrics.encode.spack.compression.FrameEncodeStream
 * @see ru.yandex.monlib.metrics.encode.spack.compression.Lz4EncodeStream
 */
public class Lz4Compressor extends AbstractFrameCompressor {
    private static final Lz4Compressor INSTANCE = new Lz4Compressor();
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    private final XxHash32Checksum checksumAlg = XxHash32Checksum.INSTANCE;

    public static Compressor newInstance() {
        return INSTANCE;
    }

    private Lz4Compressor() {
    }

    @Override
    protected void compress(ByteBuffer src, ByteBuffer dst) {
        compressor.compress(src, dst);
    }

    @Override
    protected int checksum(ByteBuffer src, int offset, int length) {
        return checksumAlg.calc(src, offset, length);
    }

    @Override
    protected int maxCompressedLength(int bytes) {
        return compressor.maxCompressedLength(bytes);
    }
}
