package ru.yandex.solomon.slog.compression.alg;

import java.nio.ByteBuffer;

import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

import ru.yandex.solomon.slog.compression.checksum.XxHash32Checksum;

/**
 * @author Vladimir Gordiychuk
 * @see ru.yandex.monlib.metrics.encode.spack.compression.FrameDecodeStream
 * @see ru.yandex.monlib.metrics.encode.spack.compression.Lz4DecodeStream
 */
public class Lz4Decompressor extends AbstractFrameDecompressor {
    private static final Lz4Decompressor INSTANCE = new Lz4Decompressor();
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
    private final XxHash32Checksum checksumAlg = XxHash32Checksum.INSTANCE;

    public static Decompressor newInstance() {
        return INSTANCE;
    }

    private Lz4Decompressor() {
    }

    @Override
    protected void decompress(ByteBuffer src, ByteBuffer dst) {
        decompressor.decompress(src, dst);
    }

    @Override
    protected int checksum(ByteBuffer dst, int offset, int length) {
        return checksumAlg.calc(dst, offset, length);
    }
}
