package ru.yandex.solomon.slog.compression.alg;

import java.nio.ByteBuffer;
import java.util.zip.Deflater;

import ru.yandex.solomon.slog.compression.checksum.Adler32Checksum;
import ru.yandex.solomon.slog.compression.checksum.Checksum;


/**
 * @author Vladimir Gordiychuk
 * @see ru.yandex.monlib.metrics.encode.spack.compression.FrameEncodeStream
 * @see ru.yandex.monlib.metrics.encode.spack.compression.ZlibEncodeStream
 */
public class ZlibCompressor extends AbstractFrameCompressor {
    private final Deflater deflater = new Deflater(6, false);
    private final Checksum checksumAlg = new Adler32Checksum();

    private ZlibCompressor() {
    }

    public static Compressor newInstance() {
        return new ZlibCompressor();
    }

    @Override
    protected void compress(ByteBuffer src, ByteBuffer dst) {
        try {
            deflater.reset();
            deflater.setInput(src);
            deflater.finish();
            deflater.deflate(dst);
        } catch (Exception e) {
            throw new RuntimeException("cannot compress block with zlib", e);
        }
    }

    @Override
    protected int checksum(ByteBuffer dst, int offset, int length) {
        return checksumAlg.calc(dst, offset, length);
    }

    //
    // As always java(tm) sucks and there is no way to estimate how many bytes
    // deflater needs in destination buffer.
    //
    // Code copy-pasted from zlib sources:
    //   https://a.yandex-team.ru/arc/trunk/arcadia/contrib/libs/zlib/compress.c?rev=3305705&blame=true#L75-80
    //
    @Override
    protected int maxCompressedLength(int sourceLen) {
        return sourceLen + (sourceLen >>> 12) + (sourceLen >>> 14) + (sourceLen >>> 25) + 13;
    }
}
