package ru.yandex.solomon.slog.compression.alg;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

import ru.yandex.solomon.slog.compression.checksum.Adler32Checksum;
import ru.yandex.solomon.slog.compression.checksum.Checksum;

/**
 * @author Vladimir Gordiychuk
 * @see ru.yandex.monlib.metrics.encode.spack.compression.FrameDecodeStream
 * @see ru.yandex.monlib.metrics.encode.spack.compression.ZlibDecodeStream
 */
public class ZlibDecompressor extends AbstractFrameDecompressor {
    private final Inflater inflater = new Inflater(false);
    private final Checksum checksumAlg = new Adler32Checksum();

    private ZlibDecompressor() {
    }

    public static Decompressor newInstance() {
        return new ZlibDecompressor();
    }

    @Override
    protected void decompress(ByteBuffer src, ByteBuffer dst) {
        try {
            inflater.reset();
            inflater.setInput(src);
            int uncompressedBytes = inflater.inflate(dst);
            if (dst.remaining() != 0) {
                throw new RuntimeException("zlib stream is corrupted: " + uncompressedBytes + " remaining " + dst.remaining());
            }
            if (!inflater.finished()) {
                throw new RuntimeException("zlib stream is corrupted: not properly finished");
            }
        } catch (DataFormatException e) {
            throw new RuntimeException("zlib stream is corrupted", e);
        }
    }

    @Override
    protected int checksum(ByteBuffer dst, int offset, int length) {
        return checksumAlg.calc(dst, offset, length);
    }
}
