package ru.yandex.solomon.slog.compression.checksum;

import java.nio.ByteBuffer;
import java.util.zip.Adler32;


/**
 * @author Sergey Polovko
 */
public final class Adler32Checksum extends Adler32 implements Checksum {

    @Override
    public int calc(byte[] buffer, int offset, int length) {
        reset();
        update(buffer, offset, length);
        return (int) getValue();
    }

    @Override
    public int calc(ByteBuffer buffer, int offset, int length) {
        reset();
        int pos = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(offset);
            buffer.limit(offset + length);
            update(buffer);
        } finally {
            buffer.position(pos);
            buffer.limit(limit);
        }
        return (int) getValue();
    }
}
