package ru.yandex.solomon.slog.compression.checksum;

import java.nio.ByteBuffer;

/**
 * @author Sergey Polovko
 */
public interface Checksum {

    int calc(byte[] buffer, int offset, int length);

    int calc(ByteBuffer buffer, int offset, int length);

    default void check(byte[] buffer, int offset, int length, int checksum) {
        if (calc(buffer, offset, length) != checksum) {
            throw new RuntimeException("stream corrupted: checksum mismatch");
        }
    }
}
