package ru.yandex.solomon.slog.compression.checksum;

import java.nio.ByteBuffer;

import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;


/**
 * @author Sergey Polovko
 */
public class XxHash32Checksum implements Checksum {
    public static XxHash32Checksum INSTANCE = new XxHash32Checksum();

    private static final int SEED = 0x1337c0de;

    private final XXHash32 impl = XXHashFactory.fastestInstance().hash32();

    private XxHash32Checksum() {
    }

    @Override
    public int calc(byte[] buffer, int offset, int length) {
        return impl.hash(buffer, offset, length, SEED);
    }

    @Override
    public int calc(ByteBuffer buffer, int offset, int length) {
        return impl.hash(buffer, offset, length, SEED);
    }
}
