package ru.yandex.solomon.slog;

import java.util.concurrent.ThreadLocalRandom;

import io.netty.buffer.ByteBufAllocator;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class LogsIndexSerializerTest {
    @Test
    public void empty() {
        var logsIndex = new LogsIndex(0);
        var serialized = LogsIndexSerializer.serialize(ByteBufAllocator.DEFAULT, logsIndex);
        try {
            LogsIndex result = LogsIndexSerializer.deserialize(serialized.retain());
            assertEquals(0, result.getSize());
        } finally {
            serialized.release();
        }
    }

    @Test
    public void serializeDeserialize() {
        var random = ThreadLocalRandom.current();
        int size = random.nextInt(1000);
        var expected = new LogsIndex(size);

        for (int index = 0; index < size; index++) {
            expected.add(random.nextInt(), random.nextInt(10000), random.nextInt(1000));
        }

        var serialized = LogsIndexSerializer.serialize(ByteBufAllocator.DEFAULT, expected);
        try {
            LogsIndex result = LogsIndexSerializer.deserialize(serialized.retain());
            assertEquals(expected.getSize(), result.getSize());
            for (int index = 0; index < expected.getSize(); index++) {
                assertEquals(expected.getNumId(index), result.getNumId(index));
                assertEquals(expected.getMetaSize(index), result.getMetaSize(index));
                assertEquals(expected.getDataSize(index), result.getDataSize(index));
            }
        } finally {
            serialized.release();
        }
    }
}
