package ru.yandex.solomon.slog;

import java.util.concurrent.ThreadLocalRandom;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Test;

import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.solomon.codec.CorruptedBinaryDataRuntimeException;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class UnresolvedLogMetaHeaderTest {
    @Test
    public void serializeDeserialize() {
        for (int index = 0; index < 10; index++) {
            var random = ThreadLocalRandom.current();
            var source = new UnresolvedLogMetaHeader(
                random.nextInt(),
                CompressionAlg.values()[random.nextInt(CompressionAlg.values().length)],
                random.nextInt(0, Integer.MAX_VALUE),
                random.nextInt(0, Integer.MAX_VALUE),
                random.nextInt(0, Integer.MAX_VALUE),
                random.nextInt(0, Integer.MAX_VALUE));

            var one = serialize(source);
            var two = serialize(source);
            assertEquals(one, two);

            var result = new UnresolvedLogMetaHeader(one);
            assertEquals(0, one.readableBytes());
            assertEquals(result.numId, source.numId);
            assertEquals(result.version, source.version);
            assertEquals(result.compressionAlg, source.compressionAlg);
            assertEquals(result.labelNamesSize, source.labelNamesSize);
            assertEquals(result.labelValuesSize, source.labelValuesSize);
            assertEquals(result.metricsCount, source.metricsCount);
            assertEquals(result.pointsCount, source.pointsCount);
        }
    }

    @Test(expected = CorruptedBinaryDataRuntimeException.class)
    public void deserializeEmpty() {
        new UnresolvedLogMetaHeader(UnpooledByteBufAllocator.DEFAULT.buffer());
    }

    @Test(expected = CorruptedBinaryDataRuntimeException.class)
    public void deserializeSmall() {
        new UnresolvedLogMetaHeader(UnpooledByteBufAllocator.DEFAULT.buffer().writeBytes("junk".getBytes()));
    }

    @Test(expected = CorruptedBinaryDataRuntimeException.class)
    public void deserializeHugeJunk() {
        new UnresolvedLogMetaHeader(UnpooledByteBufAllocator.DEFAULT.buffer()
            .writeBytes("huge amount of junk that will be instead of original header".getBytes())
            .writeZero(128 << 10));
    }

    private ByteBuf serialize(UnresolvedLogMetaHeader source) {
        var size = source.size();
        var result = UnpooledByteBufAllocator.DEFAULT.buffer(size, size);
        source.writeTo(result);
        assertEquals(size, result.readableBytes());
        return result;
    }
}
