lexer grammar SolomonLexer;

KW_LET: 'let';
KW_BY: 'by';
KW_RETURN: 'return';

OPENING_BRACE: '{';
CLOSING_BRACE: '}';

OPENING_PAREN: '(';
COMMA: ',';
CLOSING_PAREN: ')';

OPENING_BRACKET: '[';
CLOSING_BRACKET: ']';

ARROW: '->';

PLUS: '+';
MINUS: '-';

DIV: '/';
MUL: '*';

NOT: '!';

AND: '&&';
OR: '||';

LT: '<';
GT: '>';
LE: '<=';
GE: '>=';
EQ: '==';
NE: '!=';

NOT_EQUIV: '!==';
REGEX: '=~';
NOT_REGEX: '!~';

QUESTION: '?';
COLON: ':';

ASSIGNMENT: '=';
SEMICOLON: ';';

fragment IDENT_START: [a-zA-Z_];
fragment IDENT_MID: [a-zA-Z0-9_];
fragment IDENT_MID_OR_DOT: [a-zA-Z0-9_.];

IDENT_WITH_DOTS
    : IDENT_START IDENT_MID* '.' IDENT_MID_OR_DOT*
    ;

IDENT
    : IDENT_START IDENT_MID*
    ;

fragment DIGIT: [0-9];
fragment SCALE_SUFFIX: [kMGTPE];

DURATION
    : (DIGIT+ ('ms' | [wdhms]))+
    ;

NUMBER
    : DIGIT* '.'? DIGIT+ ([eE] [-+]? DIGIT+)? SCALE_SUFFIX?
    ;

fragment SQ: ['];
fragment DQ: ["];
fragment SQ_CHAR: ~[\\'] | ([\\].);
fragment DQ_CHAR: ~[\\"] | ([\\].);

STRING
    : SQ SQ_CHAR* SQ
    | DQ DQ_CHAR* DQ
    ;

/*
@see java.lang.Character.isWhitespace(int)
*/
WS: [ \t\n\u000b\f\r\u001c\u001d\u001e\u001f]+ -> skip;

COMMENTS: '//' (~[\r\n])* -> skip;
