parser grammar SolomonParser;

options { tokenVocab = SolomonLexer; }

program
    : preamble block EOF;

programWithReturn
    : preamble block expression EOF
    | preamble block KW_RETURN expression SEMICOLON EOF
    ;

preamble
    : use*
    ;

block
    : statement*
    ;

statement
    : anonymous
    | assignment
    ;

anonymous
    : expression SEMICOLON
    ;

assignment
    : KW_LET IDENT ASSIGNMENT expression SEMICOLON
    ;

use
    : IDENT selectors SEMICOLON
    ;

expression
    : lambda
    | exprOr (QUESTION exprOr COLON exprOr)?
    ;

lambda
    : IDENT ARROW expression
    | OPENING_PAREN arglist CLOSING_PAREN ARROW expression
    ;

arglist
    : IDENT (COMMA IDENT)*
    ;

exprOr: exprAnd (OR exprAnd)*;

exprAnd: exprNot (AND exprNot)*;

exprNot: NOT? exprComp;

exprComp: exprArith ((LT | GT | LE | GE | EQ | NE) exprArith)*;

exprArith: exprTerm ((PLUS | MINUS) exprTerm)*;

exprTerm: exprUnary ((DIV | MUL) exprUnary)*;

exprUnary: (PLUS | MINUS)? atom;

atom
    : OPENING_PAREN expression CLOSING_PAREN # AtomExpressionInParentheses
    | OPENING_BRACKET sequence CLOSING_BRACKET # AtomVector
    | selectors # AtomSelectors
    | DURATION # AtomDuration
    | NUMBER # AtomNumber
    | STRING # AtomString
    | lambda # AtomLambda
    | IDENT # AtomIdent
    | call # AtomCall
    | call KW_BY DURATION # AtomCallByDuration
    | call KW_BY identOrString # AtomCallByLabel
    | call KW_BY OPENING_PAREN identOrString (COMMA identOrString)* CLOSING_PAREN # AtomCallByLabels
    ;

call: IDENT OPENING_PAREN arguments CLOSING_PAREN;

arguments
    : sequence
    |
    ;

sequence: expression (COMMA expression)*;

selectors: (identOrString | IDENT_WITH_DOTS)? OPENING_BRACE selectorList CLOSING_BRACE;

selectorList: selector (COMMA selector)*;

selector: identOrString selectorType (identOrString | labelAbsent);

selectorType
    : ASSIGNMENT | NE
    | EQ | NOT_EQUIV
    | REGEX | NOT_REGEX
    ;

labelAbsent: MINUS;

identOrString: IDENT | STRING;
