package ru.yandex.solomon.staffOnly.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Special annotation to hide some beans from staffOnly manager.
 * It places here to prevent cyclic dependency beteween solomon-gateway-core and solomon-staffOnly.
 *
 * @author Oleg Baryshnikov
 */
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface HideFromManagerUi {
}
