package ru.yandex.solomon.staffOnly.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author Maksim Leonov (nohttp@)
 *         <p>
 *         Used to mark methods as debug methods used from manager.
 *         Idea may be set up for suppressing 'unused' warning for methods with this annotation.
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ManagerMethod {

    /**
     * Determines which HTTP method will be used to send form for method execution.
     */
    ExecuteMethod executeMethod() default ExecuteMethod.GET;

    enum ExecuteMethod {
        GET, POST
    }
}
