package ru.yandex.solomon.staffOnly;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;


/**
 * @author Sergey Polovko
 * @author Nuradil Zhambyl
 */

@RestController
public class BalancerController {

    // Проверка живости реалов у балансера newsolomon.yandex-team.ru осуществляется проверкой
    // MD5 суммы ответа сервера на запрос урла URL=/balancer-ping
    // (этот урл прокидывается без изменений и авторизации на localhost:5540 - salmon.frontend)
    //
    // Верным ответом считается OK заглавными латинскими буквами, два байта, без перевода строки,
    // md5sum == e0aa021e21dddbd6d8cecec71e9cf564
    //
    // knuzhdin@

    private final OkProvider[] oks;
    private final AtomicBoolean allOk;

    @Autowired
    public BalancerController(Optional<OkProvider[]> oks) {
        this.oks = oks.orElseGet(() -> new OkProvider[0]);
        allOk = new AtomicBoolean(false);
    }

    @RequestMapping(value = "/balancer-ping", produces = "text/plain")
    @ResponseBody
    public String balancerPing() {
        if (!allOk.get()) {
            List<OkProvider.Status> statuses = Arrays.stream(oks)
                    .flatMap(ok -> Arrays.stream(ok.statuses()))
                    .collect(Collectors.toList());
            allOk.set(statuses.stream().allMatch(s -> s.ok));
        }
        return allOk.get() ? "OK" : "ERROR";
    }
}
