package ru.yandex.solomon.staffOnly;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;

import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.staffOnly.manager.flamegraph.FlameGraphProducer;
import ru.yandex.solomon.staffOnly.manager.flamegraph.FlameGraphProducerImpl;

/**
 * @author Ivan Tsybulin
 */
@Configuration
public class FlameGraphContext {
    @Bean
    public FlameGraphProducer flameGraphProducer(ThreadPoolProvider threadPoolProvider) {
        return new FlameGraphProducerImpl(threadPoolProvider.getSchedulerExecutorService());
    }

    @Component
    public static class WebFluxConfig implements WebFluxConfigurer {
        @Override
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
        }
    }
}
