package ru.yandex.solomon.staffOnly;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

/**
 * @author Vladimir Gordiychuk
 */
@ControllerAdvice
public class RedirectExceptionHandler {

    @ExceptionHandler(RedirectException.class)
    public ResponseEntity<String> handleRedirectException(RedirectException ex, ServerHttpRequest request) {
        return ResponseEntity.status(HttpStatus.FOUND)
                .header(HttpHeaders.LOCATION, ex.getLocation())
                .build();
    }
}
