package ru.yandex.solomon.staffOnly;

import javax.annotation.Nonnull;

import ru.yandex.solomon.staffOnly.www.Link;

/**
 * @author Stepan Koltsov
 */
public class RootLink {

    @Nonnull
    private final String href;
    @Nonnull
    private final String title;

    public RootLink(@Nonnull String href, @Nonnull String title) {
        if (!href.startsWith("/") && !href.startsWith("http://") && !href.startsWith("https://")) {
            throw new RuntimeException("incorrect href: " + href);
        }
        if (title.isEmpty()) {
            throw new RuntimeException("title cannot be empty");
        }
        this.href = href;
        this.title = title;
    }

    @Nonnull
    public String getHref() {
        return href;
    }

    @Nonnull
    public String getTitle() {
        return title;
    }

    public Link toLink() {
        return new Link(href, title);
    }
}
