package ru.yandex.solomon.staffOnly;

import ru.yandex.library.svnversion.VcsVersion;

/**
 * @author Stepan Koltsov
 */
public final class SolomonVersion {
    private SolomonVersion() {}

    private static final VcsVersion VCS = new VcsVersion(SolomonVersion.class);
    public static final SolomonVersion VERSION = new SolomonVersion();

    public static String readRaw() {
        return String.format(
            "project.svn.rev: %d\n" +
            "project.svn.url: %s\n" +
            "build.date: %s\n" +
            "build.host: %s\n" +
            "build.user: %s\n",
            VCS.getProgramSvnRevision(),
            VCS.getArcadiaSourceUrl(),
            VCS.getProgramBuildDate(),
            VCS.getProgramBuildHost(),
            VCS.getProgramBuildUser());
    }

    public String getSvnRev() {
        return String.valueOf(VCS.getProgramSvnRevision());
    }

    public String getBuildDate() {
        return VCS.getProgramBuildDate();
    }
}
