package ru.yandex.solomon.staffOnly;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.UrlBuilder;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class UrlUtils {
    public static String hrefWithParam(String name, String value, String pagePath, Map<String, String> params) {
        UrlBuilder urlBuilder = new UrlBuilder(pagePath);
        params.forEach((pn, pv) -> {
            if (!pn.equals(name)) {
                urlBuilder.appendQueryArg(pn, pv);
            }
        });
        urlBuilder.appendQueryArg(name, value);
        return urlBuilder.build();
    }
}
