package ru.yandex.solomon.staffOnly.html;

import javax.annotation.Nonnull;

import ru.yandex.solomon.staffOnly.manager.ManagerWriter;
import ru.yandex.solomon.staffOnly.manager.WritableToHtml;

/**
 * @author Stepan Koltsov
 */
public class AHref implements WritableToHtml {
    private final String href;
    private final Object title;

    public AHref(String href, Object title) {
        this.href = href;
        this.title = title;
    }

    @Override
    public void writeTo(@Nonnull ManagerWriter managerWriter) {
        managerWriter.getHtmlWriter().aHref(href, () -> managerWriter.writeCellValue(title));
    }
}
