package ru.yandex.solomon.staffOnly.html;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class CssLine {

    private final String name;
    private final String value;

    public CssLine(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Nonnull
    public static CssLine fontFamilyMonospace() {
        return fontFamily("monospace");
    }

    @Nonnull
    private static CssLine fontFamily(String family) {
        return new CssLine("font-family", family);
    }

    public String format() {
        return name + ": " + value;
    }

    @Override
    public String toString() {
        return format();
    }
}
