package ru.yandex.solomon.staffOnly.html;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.CollectorsF;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class HtmlAttrs {

    private LinkedHashMap<String, String> map;

    public HtmlAttrs() {
        this.map = new LinkedHashMap<>();
    }

    public HtmlAttrs(List<HtmlWriter.Attr> attrs) {
        this.map = attrs.stream()
            .collect(CollectorsF.toJavaUtilLinkedHashMap(
                HtmlWriter.Attr::getName,
                HtmlWriter.Attr::getValue));
    }


    public void setDefault(String name, String value) {
        map.putIfAbsent(name, value);
    }

    public void setDefault(HtmlWriter.Attr attr) {
        setDefault(attr.getName(), attr.getValue());
    }

    public List<HtmlWriter.Attr> buildList() {
        return map.entrySet().stream()
            .map(e -> new HtmlWriter.Attr(e.getKey(), e.getValue()))
            .collect(Collectors.toList());
    }
}
