package ru.yandex.solomon.staffOnly.html;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

import javax.annotation.Nonnull;

import ru.yandex.solomon.staffOnly.manager.ManagerWriter;
import ru.yandex.solomon.staffOnly.manager.WritableToHtml;
import ru.yandex.solomon.util.ExceptionUtils;


/**
 * @author Sergey Polovko
 */
public class HtmlError implements WritableToHtml {

    private static final DateTimeFormatter formatter =
        DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")
        .withZone(ZoneId.of("Europe/Moscow"));

    private final Instant time;
    private final Throwable error;

    public HtmlError(Instant time, Throwable error) {
        this.time = time;
        this.error = error;
    }

    @Override
    public void writeTo(@Nonnull ManagerWriter managerWriter) {
        HtmlWriterWithCommonLibraries hw = managerWriter.getHtmlWriter();

        hw.p(error.getMessage());
        hw.p("At " + formatter.format(time));

        if (error.getStackTrace().length > 0) {
            hw.preText(ExceptionUtils.printStackTrace(error));
        }
    }
}
