package ru.yandex.solomon.staffOnly.html;

import java.util.List;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * @author Stepan Koltsov
 */
public abstract class HtmlWriterWithCommonLibraries extends HtmlWriter {
    public void commonCssJs() {
        linkStylesheet("https://yastatic.net/bootstrap/3.0.2/css/bootstrap.css");
        scriptHref("https://yastatic.net/jquery/2.0.3/jquery.js");
        scriptHref("https://yastatic.net/bootstrap/3.0.2/js/bootstrap.js");
    }

    public void divContainer(Callback content) {
        tag("div.container", content);
    }

    public void divContainerFluid(Callback content) {
        tag("div.container-fluid", content);
    }

    public void scriptFunction(Callback content) {
        script(() -> {
            line("$(function() {");
            content.run();
            line("});");
        });
    }

    public void hnWithSmall(int n, String large, String small) {
        hn(n, () -> {
            write(large);
            write(" ");
            small(small);
        }, Attr.style("word-wrap: break-word"));
    }

    public void h1WithSmall(String large, String small) {
        hnWithSmall(1, large, small);
    }

    public void h2WithSmall(String large, String small) {
        hnWithSmall(2, large, small);
    }

    public void h3WithSmall(String large, String small) {
        hnWithSmall(3, large, small);
    }

    public void h4WithSmall(String large, String small) {
        hnWithSmall(4, large, small);
    }

    public void h5WithSmall(String large, String small) {
        hnWithSmall(5, large, small);
    }

    public void h6WithSmall(String large, String small) {
        hnWithSmall(6, large, small);
    }

    public void tableTable(Callback content) {
        tag("table.table", content);
    }

    public void inputCheckbox(String id, String name, String value) {
        tag("input",
                new Attr("id", id),
                new Attr("type", "checkbox"),
                new Attr("name", name),
                new Attr("value", value),
                new Attr("class", ""));
    }

    public void inputTextfieldFormControl(String id, String name, String value) {
        tag("input",
                new Attr("id", id),
                new Attr("type", "textfield"),
                new Attr("name", name),
                new Attr("value", value),
                new Attr("class", "form-control"));
    }

    public void selectFormControl(String id, String name, List<String> values, String defaultValue) {
        tag("select.form-control", () -> {
            tag("option", () -> write(defaultValue));
            for (String value : values) {
                if (value.equals(defaultValue)) {
                    continue;
                }
                tag("option", () -> write(value));
            }
        }, new Attr("id", id), new Attr("name", name));
    }

    public void buttonSubmitDefault(String title) {
        tag("button.btn.btn-default type=submit", () -> write(title));
    }

    public void inputGroup(Callback content) {
        divWithClass("input-group", content);
    }

    public void inputGroupBtn(Callback content) {
        divWithClass("input-group-btn", content);
    }

    public void label(String type, Callback content) {
        tag("span", new Attr("class", "label label-" + type), content);
    }

    public void label(String type, String content) {
        tag("span", new Attr("class", "label label-" + type), () -> write(content));
    }

    public void progress(double percent) {
        tag("div.progress", () -> {
            tag("div.progress-bar", () -> write(String.format("%.2f%%", percent)),
                new Attr("role", "progressbar"),
                new Attr("style", String.format("width: %d%%", Math.round(percent))));
        });
    }

    public void panel(String title, Callback content) {
        tag("div.panel.panel-default", () -> {
            tag("div.panel-heading", () -> {
                h3(() -> write(title), Attr.cssClass("panel-title"));
            });
            tag("div.panel-body", content);
        });
    }

    public void panelNoBody(String title, Callback content) {
        tag("div.panel.panel-default", () -> {
            tag("div.panel-heading", () -> {
                h3(() -> write(title), Attr.cssClass("panel-title"));
            });
            content(content);
        });
    }

    public void gridXs(int n, Callback content) {
        checkArgument(n >= 1 && n <= 12);
        tag("div.col-xs-" + n, content);
    }
}
