package ru.yandex.solomon.staffOnly.html.svg;

import java.lang.reflect.InaccessibleObjectException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.solomon.staffOnly.html.HtmlWriter;
import ru.yandex.solomon.staffOnly.html.TagNameAndAttrs;

/**
 * @author Stepan Koltsov
 */
public abstract class ManagerSvgElement {

    protected abstract String tagName();

    public String id;

    public TagNameAndAttrs toTagNameAndAttrs() {
        return new TagNameAndAttrs(tagName(), ClassX.getClass(this).getAllDeclaredInstanceFields().filterMap(f -> {
            try {
                f.setAccessible(true);
            } catch (InaccessibleObjectException | SecurityException e) {
                return Option.none();
            }

            Object value = f.get(this);
            if (value == null) {
                return Option.none();
            }

            if (value instanceof Integer) {
                int valueInt = (int) value;
                if (valueInt == 0) {
                    return Option.none();
                }
            }

            return Option.some(new HtmlWriter.Attr(f.getName(), value.toString()));
        }));
    }
}
