package ru.yandex.solomon.staffOnly.manager;

import java.lang.reflect.Array;
import java.util.AbstractList;

/**
 * @author Stepan Koltsov
 */
public class ArrayAsList extends AbstractList<Object> {
    private final Object array;

    public ArrayAsList(Object array) {
        if (array == null || !array.getClass().isArray()) {
            throw new IllegalArgumentException("cannot convert object to array");
        }
        this.array = array;
    }

    @Override
    public Object get(int index) {
        return Array.get(array, index);
    }

    @Override
    public int size() {
        return Array.getLength(array);
    }
}
