package ru.yandex.solomon.staffOnly.manager;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * @author Stepan Koltsov
 */
public class CollectionToString {
    private static <A> String collectionToStringImpl(
        @Nullable Collection<A> collection, Function<A, String> elementFormat, int maxLength, String open, String close)
    {
        if (collection == null) {
            return "null";
        }

        StringBuilder inner = new StringBuilder();

        int i = 0;
        for (A o : collection) {
            if (i != 0) {
                inner.append(", ");
            }
            i += 1;

            // TODO: break before if exceded length
            inner.append(elementFormat.apply(o));

            if (inner.length() >= maxLength) {
                return open + collection.size() + ": " + inner + "..." + close;
            }
        }

        return open + inner + close;
    }

    @Nonnull
    public static String collectionToString(@Nullable Collection<?> collection, int maxLength) {
        return collectionToStringImpl(collection, Objects::toString, maxLength, "[", "]");
    }

    @Nonnull
    public static String mapToString(@Nullable Map<?, ?> map, int maxLength) {
        if (map == null) {
            return "null";
        }

        return collectionToStringImpl(map.entrySet(), e -> e.getKey() + "=" + e.getValue(), maxLength, "{", "}");
    }
}
