package ru.yandex.solomon.staffOnly.manager;

import ru.yandex.solomon.staffOnly.html.HtmlWriterWithCommonLibraries;
import ru.yandex.solomon.staffOnly.manager.special.ExtraContent;

/**
 * @author Stepan Koltsov
 */
public class ExtraContentParam {

    private final HtmlWriterWithCommonLibraries htmlWriter;
    private final ManagerWriterContext managerWriterContext;

    public ExtraContentParam(HtmlWriterWithCommonLibraries htmlWriter, ManagerWriterContext managerWriterContext) {
        this.htmlWriter = htmlWriter;
        this.managerWriterContext = managerWriterContext;
    }

    public HtmlWriterWithCommonLibraries getHtmlWriter() {
        return htmlWriter;
    }

    public ManagerWriterContext getManagerWriterContext() {
        return managerWriterContext;
    }

    public ManagerWriter managerWriter() {
        return new ManagerWriter(managerWriterContext, htmlWriter);
    }

    public void subh(String content) {
        htmlWriter.hn(ExtraContent.H + 1, content);
    }
}
