package ru.yandex.solomon.staffOnly.manager;

import java.util.function.Function;

import javax.annotation.Nullable;

import com.google.common.base.Strings;

import ru.yandex.bolts.type.number.PrimitiveType;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author Sergey Polovko
 */
public class ParameterParser {

    public static Object parse(String str, TypeX type) {
        ClassX<Object> clazz = type.erasure();
        if (clazz.isAssignableFrom(String.class)) {
            return str;
        }

        if (clazz.isPrimitiveOrWrapper()) {
            PrimitiveType<?, ?> primitiveType = PrimitiveType.forPrimitiveClassOrWrapper(clazz.getClazz()).get();
            return Strings.isNullOrEmpty(str) ? clazz.defaultValue() : primitiveType.parse(str);
        }

        if (clazz.isEnum()) {
            return Strings.isNullOrEmpty(str)
                    ? clazz.defaultValue()
                    : Enum.valueOf((Class) clazz.getClazz(), str);
        }

        throw new IllegalStateException("cannot parse " + type);
    }

    @Nullable
    public static Function<String, Object> createParser(TypeX type) {
        ClassX<Object> clazz = type.erasure();
        if (clazz.isAssignableFrom(String.class)) {
            return s -> s;
        }

        if (clazz.isPrimitiveOrWrapper()) {
            PrimitiveType<?, ?> primitiveType = PrimitiveType.forPrimitiveClassOrWrapper(clazz.getClazz()).get();
            return s -> Strings.isNullOrEmpty(s) ? clazz.defaultValue() : primitiveType.parse(s);
        }

        return null;
    }
}
