package ru.yandex.solomon.staffOnly.manager.find;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface NamedObject {

    default String namedObjectClassId() {
        Class<? extends NamedObject> aClass = this.getClass();
        return defautNamedObjectClassIdForClass(aClass);
    }

    static String defautNamedObjectClassIdForClass(Class<?> aClass) {
        return aClass.getName();
    }

    String namedObjectId();

    default NamedObjectId namedObjectIdGlobal() {
        return new NamedObjectId(namedObjectClassId(), namedObjectId());
    }

}
