package ru.yandex.solomon.staffOnly.manager.find;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class NamedObjectId {

    private final String classId;
    private final String instanceId;

    public NamedObjectId(String classId, String instanceId) {
        this.classId = classId;
        this.instanceId = instanceId;
    }

    public NamedObjectId(Class<?> classId, String instanceId) {
        this(NamedObject.defautNamedObjectClassIdForClass(classId), instanceId);
    }

    @Nonnull
    public String getClassId() {
        return classId;
    }

    @Nonnull
    public String getInstanceId() {
        return instanceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NamedObjectId that = (NamedObjectId) o;

        if (!classId.equals(that.classId)) return false;
        return instanceId.equals(that.instanceId);

    }

    @Override
    public int hashCode() {
        int result = classId.hashCode();
        result = 31 * result + instanceId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return classId + "/" + instanceId;
    }
}
