package ru.yandex.solomon.staffOnly.manager.flamegraph;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface FlameGraphProducer {

    enum State {
        EMPTY,
        RUNNING,
        DONE,
    }

    record StateChanged(State currentState, Instant since) {
    }

    record FlameGraphWithTime(Trie.ImmutableTrieNode flameGraph, Instant time) {
    }

    void setThreadNameRegex(String regex);
    String getThreadNameRegex();

    void setMaxStackDepth(int depth);
    int getMaxStackDepth();

    void setDropFramesPercent(double dropFramesPercent);
    double getDropFramesPercent();

    void setSamplingFrequency(int frequency);
    int getSamplingFrequency();

    void start();
    void stop();
    void refresh();
    FlameGraphWithTime get();
    StateChanged getStateChanged();
}
