package ru.yandex.solomon.staffOnly.manager.flamegraph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Trie {

    private final TrieNode root = new TrieNode();

    synchronized public void insert(Iterator<String> path) {
        root.insert(path);
    }

    synchronized public ImmutableTrieNode snapshot() {
        return root.cloneToImmutable();
    }

    private static class TrieNode {
        private Map<String, TrieNode> children = null;
        private long counter = 0;

        private Map<String, TrieNode> getChildren() {
            if (children == null) {
                children = new HashMap<>();
            }
            return children;
        }

        private void insert(Iterator<String> path) {
            counter++;
            if (!path.hasNext()) {
                return;
            }
            getChildren().computeIfAbsent(path.next(), ignore -> new TrieNode()).insert(path);
        }

        private ImmutableTrieNode cloneToImmutable() {
            return new ImmutableTrieNode(
                    children == null ? Map.of() :
                    children.entrySet().stream()
                        .collect(Collectors.toUnmodifiableMap(
                                Map.Entry::getKey,
                                e -> e.getValue().cloneToImmutable()
                        )),
                    counter
            );
        }
    }

    public static record ImmutableTrieNode(Map<String, ImmutableTrieNode> children, long counter) {
        public static final ImmutableTrieNode EMPTY = new ImmutableTrieNode(Map.of(), 0);
    }
}
