package ru.yandex.solomon.staffOnly.manager.ok;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Stepan Koltsov
 *
 * https://st.yandex-team.ru/SOLOMON-1129
 */
@Import(OkProviderMetrics.class)
@RestController
public class OkController {
    private final OkProvider[] oks;

    @Autowired
    public OkController(Optional<OkProvider[]> oks) {
        this.oks = oks.orElseGet(() -> new OkProvider[0]);
    }

    @RequestMapping("/ok")
    public ResponseEntity<String> ok() {
        OkProvider[] oks = this.oks != null ? this.oks : new OkProvider[0];
        List<OkProvider.Status> statuses = Arrays.stream(oks)
            .flatMap(ok -> Arrays.stream(ok.statuses()))
            .collect(Collectors.toList());

        boolean allOk = statuses.stream().allMatch(s -> s.ok);

        StringBuilder sb = new StringBuilder();
        sb.append(allOk ? "ok" : "error").append("\n");
        for (OkProvider.Status status : statuses) {
            sb.append(status.toString() + "\n");
        }

        return new ResponseEntity<>(sb.toString(), allOk ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR);
    }
}
